/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.utility.Paging;
import org.intellij.lang.annotations.Language;

public class Paging {
    private final boolean isPagination;
    @Language(value="SQL")
    private final String tableName;
    private final int itemsPerPage;
    private final int page;

    public Paging(int itemsPerPage, int page, @Language(value="SQL") String tableName) {
        this.itemsPerPage = itemsPerPage;
        this.page = page;
        this.tableName = tableName;
        this.isPagination = page > 0 && itemsPerPage > 0;
    }

    public String makeSql(PageSqlData sqlData) {
        return this.buildQueryMaker().makeQuery(sqlData);
    }

    private QueryMaker buildQueryMaker() {
        return this.isPagination ? new PagedQueryMaker(this.itemsPerPage, this.page) : new NormalQueryMaker(null);
    }

    public boolean isPagination() {
        return this.isPagination;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getPage() {
        return this.page;
    }
}

